#ifndef _TSDIRECTGRAPHICS_H_
#define _TSDIRECTGRAPHICS_H_

#pragma	comment(lib,"winmm.lib")
#pragma	comment(lib,"d3d9.lib")
#pragma	comment(lib,"d3dx9.lib")
#pragma	comment(lib,"dxguid.lib")

/****************************************/
/*	CN[h						*/
/****************************************/
#include <tchar.h>
#include <d3dx9.h>

/****************************************/
/*	萔錾							*/
/****************************************/
#define D3DSCENE_MAX 8		//V[̍ő吔
#define TEXTURE_MAX 16384	//eNX`̍ő吔
#define RENDERTEX_MAX 12	//_OeNX`̍ő吔
#define SHADER_EFFECT_MAX 8	//VF[_̃GtFNgő吔
/****************************************/
/*	\̐錾							*/
/****************************************/
//eNX`Qc_f[^
#define FVF_WDVERTEX (D3DFVF_XYZRHW|D3DFVF_DIFFUSE)
typedef struct{
	float x,y,z;
	float rhw;
	D3DCOLOR color;
}WDVERTEX;
//eNX`LQc_f[^
#define FVF_WDTVERTEX (D3DFVF_XYZRHW|D3DFVF_DIFFUSE|D3DFVF_TEX1)
typedef struct{
	float x,y,z;
	float rhw;
	D3DCOLOR color;
	float tu,tv;
}WDTVERTEX;

typedef struct{
	int w,h;
	D3DFORMAT format;
}RENDERTEX_PARAM;

/****************************************/
/*	NX錾							*/
/****************************************/
class tsDirectGraphics{
protected:
	int errMode;									//G[\[h
	HWND hwnd[D3DSCENE_MAX];						//EChEnh
	LPDIRECT3D9 lpD3D;								//DirectX9IuWFNg̃|C^
	LPDIRECT3DDEVICE9 lpD3DDevice;					//DirectX9foCX̃|C^
	int selScene;									//I𒆂̃V[
	bool enable[D3DSCENE_MAX];						//V[̗LtO
	D3DPRESENT_PARAMETERS d3dpp[D3DSCENE_MAX];		//DirectX9p[^
	IDirect3DSwapChain9	*swapChain[D3DSCENE_MAX];	//Xbv`F[
	LPDIRECT3DSURFACE9 lpBackBuffer[D3DSCENE_MAX];	// obNobt@
	LPDIRECT3DSURFACE9 lpZBuffer;					// Zobt@(Lj
	
	float WHrate[D3DSCENE_MAX];						//XN[̕A̔䗦
	D3DVIEWPORT9 standerdViewData[D3DSCENE_MAX];	//Wr[f[^
	LPD3DXSPRITE lpSprite;							//Direct3DXXvCgIuWFNg̃|C^
	LPD3DXFONT lpFont;								//Direct3DXtHgIuWFNg̃|C^
	LPD3DXLINE lpLine;								//2DLiinep|C^
	LPDIRECT3DTEXTURE9 lpTexture[TEXTURE_MAX];		//eNX`ւ̃|C^
	LPDIRECT3DTEXTURE9 lpRenderTex[RENDERTEX_MAX];	//_OpeNX`
	LPDIRECT3DSURFACE9 lpRenderSur[RENDERTEX_MAX];	//_OpeNX`T[tFCX
	RENDERTEX_PARAM renderTexParam[RENDERTEX_MAX];	//_O^[QbgAp
	bool spriteDrawMode;							//XvCg`撆tO
	D3DXMATRIX identityMatrix;						//Pʍs
	//VF[_[֌W
	LPD3DXEFFECT lpEffect[SHADER_EFFECT_MAX];		//GtFNg
	UINT effectPass[SHADER_EFFECT_MAX];
	//foCXAp
	void (*cleanFunc)(void);
	void(*initFunc)(void);
	//
	bool errPrint(LPCTSTR capt,LPCTSTR mess,...);
public:
	tsDirectGraphics(int errMode);
	~tsDirectGraphics();
	bool checkResult(void);
	bool initialize(HWND hwnd,int width,int height,bool fullScreen,int sync=1,int refresh=60,int dispMode=-1,D3DSWAPEFFECT swapEffect=D3DSWAPEFFECT_COPY,UINT adapter=D3DADAPTER_DEFAULT,bool stencile=false);
	bool addScene(int scene,HWND hwnd,int width,int height,int sync=1,int refresh=60,int dispMode=-1,D3DSWAPEFFECT swapEffect=D3DSWAPEFFECT_COPY,UINT adapter=D3DADAPTER_DEFAULT);
	bool selectScene(int scene);
	void deviceResetFunc(void(*cleanFunc)(void)=NULL,void(*initFunc)(void)=NULL);
	void deviceClean(void);
	bool deviceInit(void);
	bool resizeFrameBuffer(int width,int height);
	bool changeWindowMode(int mode=-1,UINT refresh=D3DPRESENT_RATE_DEFAULT,int dispMode=-1);
	void clear(D3DCOLOR color=D3DCOLOR_XRGB(0,0,0),int rectNum=0,D3DRECT *rect=NULL,DWORD flag=D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER);
	void clearZ(int rectNum=0,D3DRECT *rect=NULL,float z=1.0f);
	void clearStencil(int rectNum=0,D3DRECT *rect=NULL,DWORD stencil=0);
	void beginScene(void);
	void endScene(void);
	bool drawScene(RECT *srect=NULL,RECT *drect=NULL);
	bool setViewport(void);
	bool setViewport(D3DVIEWPORT9 *viewport);
	void backClip(int state);
	void enableZ(bool state);
	void enableMask(void);
	void setAlphaState(int mode);
	void setAlphaTest(bool flag,DWORD alpha=0);
	void setZWrite(bool flag);
	void setTextureFilter(DWORD filter=D3DTEXF_LINEAR);
	void setPointSize(float size=1.0f);
	void selectTexture(int stage,int num,bool rend=false);
	LPDIRECT3DDEVICE9 getDevice(void);
	D3DPRESENT_PARAMETERS *getPParam(void);
	int getSelectScene(void);
	LPDIRECT3DTEXTURE9 *getTexture(int texture,bool rend=false);
	bool loadTexture(int num,LPCTSTR fname,D3DCOLOR colKey=0,D3DFORMAT format=D3DFMT_UNKNOWN,D3DXIMAGE_INFO *srcInfo=NULL,DWORD filter=D3DX_FILTER_LINEAR,UINT mipLevel=1/*D3DX_DEFAULT*/,int w=0,int h=0,D3DPOOL pool=D3DPOOL_MANAGED);
	bool loadTexture(int num,void *ptr,UINT size,D3DCOLOR colKey=0,D3DFORMAT format=D3DFMT_UNKNOWN,D3DXIMAGE_INFO *srcInfo=NULL,DWORD filter=D3DX_FILTER_LINEAR,UINT mipLevel=1/*D3DX_DEFAULT*/,int w=0,int h=0,D3DPOOL pool=D3DPOOL_MANAGED);
	bool loadTexture(int num,LPD3DXBUFFER ptr,D3DCOLOR colKey=0,D3DFORMAT format=D3DFMT_UNKNOWN,D3DXIMAGE_INFO *srcInfo=NULL,DWORD filter=D3DX_FILTER_LINEAR,UINT mipLevel=1/*D3DX_DEFAULT*/,int w=0,int h=0,D3DPOOL pool=D3DPOOL_MANAGED);
	bool createTexture(int num,D3DXIMAGE_INFO *imageInfo,D3DPOOL pool=D3DPOOL_MANAGED);
	void releaseTexture(int num);
	bool checkTexture(int num);
	bool createRenderTexture(int num,int w,int h,D3DFORMAT format=D3DFMT_UNKNOWN);
	void releaseRenderTexture(int num);
	bool selectRenderTexture(int num);
	void beginSprite(DWORD flag=D3DXSPRITE_ALPHABLEND);
	void endSprite(void);
	bool setFont(int width,int height,LPCTSTR font,int style=0,DWORD charSet=SHIFTJIS_CHARSET);
	void drawText(int x,int y,D3DCOLOR color,LPCTSTR str,...);
	void drawText(LPRECT rect,D3DCOLOR color,DWORD format,LPCTSTR str,...);
	void drawSprite(int num,D3DXVECTOR2 *pos,RECT *rect=NULL,D3DXVECTOR2 *scale=NULL,D3DXVECTOR2* center=NULL,float rot=0,D3DCOLOR color=0xffffffff,bool rend=false);
	void drawSprite(LPDIRECT3DTEXTURE9 texture,D3DXVECTOR2 *pos,RECT *rect=NULL,D3DXVECTOR2 *scale=NULL,D3DXVECTOR2* center=0,float rot=0,D3DCOLOR color=0xffffffff);
	void drawLine(int num,WDVERTEX *vtx);
	void drawPolygon(int num,WDVERTEX *vtx);
	void drawPolygon(int num,int texture,WDTVERTEX *vtx,bool rend=false);
	void drawPolygon(int num,LPDIRECT3DTEXTURE9 texture,WDTVERTEX *vtx);
	void draw2DLine(int num,D3DXVECTOR2 *vtx,D3DCOLOR color,float width=1,DWORD pattern=0xffffffff);
	bool saveFrameBuffer(LPCTSTR fName,D3DXIMAGE_FILEFORMAT format=D3DXIFF_BMP);
	bool saveFrameBuffer(LPD3DXBUFFER &mptr,D3DXIMAGE_FILEFORMAT format=D3DXIFF_BMP);
	bool saveTexture(int num,LPCTSTR fName,RECT *rect,D3DXIMAGE_FILEFORMAT format=D3DXIFF_BMP,bool rend=false);
	bool saveTexture(int num,LPD3DXBUFFER &mptr,RECT *rect=NULL,D3DXIMAGE_FILEFORMAT format=D3DXIFF_BMP,bool rend=false);
	void setAlphaStateEx(int mode);
	///////////////////////////////////////
	//VF[_[֌W
	///////////////////////////////////////
	bool loadEffect(LPCTSTR fName,int num=0);
	bool loadEffectObj(LPCTSTR fName,int num=0);
	bool loadEffectFx(LPCTSTR fName,int num=0);
	void releaseEffect(int num = 0);
	LPD3DXEFFECT getEffect(int num=0);
	D3DXHANDLE getTechnique(LPCTSTR name,int num=0);
	D3DXHANDLE getParameter(LPCTSTR name,int num=0,D3DXHANDLE param=NULL);
	bool selectTechnique(D3DXHANDLE handle,int num=0);
	bool endTechnique(int num=0);
	bool selectPass(UINT pass,int num=0);
	bool endPass(int num=0);
	///////////////////////////////////////
	//ǉ@\
	///////////////////////////////////////
	void drawRect(RECT rect,D3DCOLOR color);
	void drawBrokenRect(RECT rect,int ofs,D3DCOLOR color);
	void drawBrokenCircle(D3DXVECTOR2 *pos,int r,int ofs,D3DCOLOR color);
	void drawBrokenTextureEdge(D3DXVECTOR2 *pos,int texture,int ofs,DWORD color,D3DXVECTOR2 *scale=NULL,D3DXVECTOR2* center=NULL,float rot=0);
	void drawBrokenTextureEdge(D3DXVECTOR2 *pos,LPDIRECT3DTEXTURE9 texture,int ofs,DWORD color,D3DXVECTOR2 *scale=NULL,D3DXVECTOR2* center=NULL,float rot=0);
	D3DCOLOR getTexturePixel(int texture,int x,int y);
	D3DCOLOR getTexturePixel(LPDIRECT3DTEXTURE9 texture,int x,int y);
	POINT getTextureSize(int texture,bool rend=false);
	POINT getTextureSize(LPDIRECT3DTEXTURE9 texture);
	D3DFORMAT getTextureFormat(int texture,bool rend=false);
	D3DFORMAT getTextureFormat(LPDIRECT3DTEXTURE9 texture);
};

#endif
